<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = 'تست کامل احراز هویت';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700&display=swap');
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container { max-width: 1000px; margin: 0 auto; }
        .card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        .card h2 {
            color: #667eea;
            font-size: 18px;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }
        .row {
            display: flex;
            justify-content: space-between;
            padding: 10px;
            margin: 5px 0;
            background: #f8f9fa;
            border-radius: 6px;
        }
        .label { font-weight: 600; color: #495057; }
        .value {
            font-family: monospace;
            color: #212529;
            direction: ltr;
            text-align: left;
        }
        .success { background: #d4edda !important; color: #155724 !important; }
        .error { background: #f8d7da !important; color: #721c24 !important; }
        .warning { background: #fff3cd !important; color: #856404 !important; }
        .btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 14px;
            font-weight: 600;
            margin: 5px;
        }
        .btn:hover { background: #5568d3; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 6px; font-family: monospace; font-size: 12px; overflow-x: auto; white-space: pre-wrap; word-break: break-all; margin-top: 10px; }
        #console-log { max-height: 300px; overflow-y: auto; }
        .log-entry { padding: 5px; margin: 2px 0; border-radius: 4px; font-size: 12px; font-family: monospace; }
        .log-info { background: #d1ecf1; color: #0c5460; }
        .log-success { background: #d4edda; color: #155724; }
        .log-warning { background: #fff3cd; color: #856404; }
        .log-error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>🔐 تست کامل سیستم احراز هویت</h2>
            <p style="color: #666; font-size: 14px;">این صفحه وضعیت کامل سیستم احراز هویت رو نشون می‌ده</p>
        </div>

        <!-- PHP Side -->
        <div class="card">
            <h2>🐘 PHP - وضعیت سرور</h2>
            
            <div class="row <?php echo isLoggedIn() ? 'success' : 'error'; ?>">
                <span class="label">isLoggedIn():</span>
                <span class="value"><?php echo isLoggedIn() ? '✅ TRUE' : '❌ FALSE'; ?></span>
            </div>
            
            <?php if (isset($_SESSION['user_id'])): ?>
            <div class="row success">
                <span class="label">Session User ID:</span>
                <span class="value"><?php echo htmlspecialchars($_SESSION['user_id']); ?></span>
            </div>
            <div class="row">
                <span class="label">Session Mobile:</span>
                <span class="value"><?php echo htmlspecialchars($_SESSION['mobile'] ?? 'N/A'); ?></span>
            </div>
            <div class="row">
                <span class="label">Session Email:</span>
                <span class="value"><?php echo htmlspecialchars($_SESSION['email'] ?? 'N/A'); ?></span>
            </div>
            <?php else: ?>
            <div class="row error">
                <span class="label">PHP Session:</span>
                <span class="value">❌ Session موجود نیست</span>
            </div>
            <?php endif; ?>
            
            <div class="row <?php echo isset($_COOKIE['auth_token']) ? 'success' : 'error'; ?>">
                <span class="label">Cookie (از PHP):</span>
                <span class="value"><?php echo isset($_COOKIE['auth_token']) ? '✅ موجود (' . substr($_COOKIE['auth_token'], 0, 20) . '...)' : '❌ موجود نیست'; ?></span>
            </div>
            
            <?php if (isset($_COOKIE['auth_token'])): 
                $user = getUserByToken($_COOKIE['auth_token']);
                if ($user): ?>
            <div class="row success">
                <span class="label">Token در دیتابیس:</span>
                <span class="value">✅ معتبر است (User ID: <?php echo $user['id']; ?>)</span>
            </div>
            <?php else: ?>
            <div class="row error">
                <span class="label">Token در دیتابیس:</span>
                <span class="value">❌ منقضی یا نامعتبر است</span>
            </div>
            <?php endif; endif; ?>
            
            <div class="row">
                <span class="label">Session ID:</span>
                <span class="value"><?php echo session_id(); ?></span>
            </div>
            
            <div class="row">
                <span class="label">Session Save Path:</span>
                <span class="value"><?php echo session_save_path(); ?></span>
            </div>
        </div>

        <!-- JavaScript Side -->
        <div class="card">
            <h2>📱 JavaScript - وضعیت مرورگر</h2>
            
            <div class="row" id="js-localstorage">
                <span class="label">localStorage:</span>
                <span class="value">در حال بررسی...</span>
            </div>
            
            <div class="row" id="js-cookie">
                <span class="label">Cookie (از JS):</span>
                <span class="value">در حال بررسی...</span>
            </div>
            
            <div class="row" id="js-sync">
                <span class="label">وضعیت Sync:</span>
                <span class="value">در حال بررسی...</span>
            </div>
            
            <div id="token-display"></div>
        </div>

        <!-- Console Logs -->
        <div class="card">
            <h2>📋 لاگ‌های Console</h2>
            <div id="console-log"></div>
        </div>

        <!-- Actions -->
        <div class="card">
            <h2>🛠️ عملیات</h2>
            <button class="btn" onclick="testSync()">🔄 تست Sync</button>
            <button class="btn" onclick="window.location.reload()">🔄 Reload صفحه</button>
            <button class="btn" onclick="clearAll()">🗑️ پاک کردن همه</button>
            <a href="/login.php" class="btn">🔐 صفحه لاگین</a>
            <a href="/dashboard.php" class="btn">🏠 داشبورد</a>
            <a href="/logout.php" class="btn btn-danger">🚪 خروج</a>
        </div>
    </div>

    <script>
        const logs = [];
        
        function addLog(message, type = 'info') {
            logs.push({ message, type, time: new Date().toLocaleTimeString() });
            updateLogDisplay();
        }
        
        function updateLogDisplay() {
            const logDiv = document.getElementById('console-log');
            logDiv.innerHTML = logs.map(log => 
                `<div class="log-entry log-${log.type}">[${log.time}] ${log.message}</div>`
            ).join('');
            logDiv.scrollTop = logDiv.scrollHeight;
        }
        
        // Override console.log
        const originalLog = console.log;
        const originalWarn = console.warn;
        const originalError = console.error;
        
        console.log = function(...args) {
            addLog(args.join(' '), 'info');
            originalLog.apply(console, args);
        };
        console.warn = function(...args) {
            addLog(args.join(' '), 'warning');
            originalWarn.apply(console, args);
        };
        console.error = function(...args) {
            addLog(args.join(' '), 'error');
            originalError.apply(console, args);
        };
        
        // Check localStorage
        function checkLocalStorage() {
            const token = localStorage.getItem('auth_token');
            const userData = localStorage.getItem('user_data');
            const row = document.getElementById('js-localstorage');
            
            if (token) {
                row.className = 'row success';
                row.innerHTML = `<span class="label">localStorage:</span><span class="value">✅ Token موجود (${token.substring(0, 20)}...)</span>`;
                addLog('✅ Token در localStorage یافت شد', 'success');
                
                if (userData) {
                    addLog('✅ اطلاعات کاربر: ' + userData, 'info');
                }
            } else {
                row.className = 'row error';
                row.innerHTML = `<span class="label">localStorage:</span><span class="value">❌ Token موجود نیست</span>`;
                addLog('❌ Token در localStorage یافت نشد', 'error');
            }
            
            return token;
        }
        
        // Check Cookie
        function checkCookie() {
            const cookieToken = document.cookie.split('; ').find(row => row.startsWith('auth_token='));
            const row = document.getElementById('js-cookie');
            
            if (cookieToken) {
                const token = cookieToken.split('=')[1];
                row.className = 'row success';
                row.innerHTML = `<span class="label">Cookie (از JS):</span><span class="value">✅ موجود (${token.substring(0, 20)}...)</span>`;
                addLog('✅ Cookie در مرورگر یافت شد', 'success');
                return token;
            } else {
                row.className = 'row error';
                row.innerHTML = `<span class="label">Cookie (از JS):</span><span class="value">❌ موجود نیست</span>`;
                addLog('❌ Cookie در مرورگر یافت نشد', 'error');
                return null;
            }
        }
        
        // Test Sync
        function testSync() {
            addLog('🔄 شروع تست Sync...', 'info');
            
            const localToken = checkLocalStorage();
            const cookieToken = checkCookie();
            const syncRow = document.getElementById('js-sync');
            
            if (localToken && cookieToken) {
                if (localToken === cookieToken) {
                    syncRow.className = 'row success';
                    syncRow.innerHTML = `<span class="label">وضعیت Sync:</span><span class="value">✅ کاملاً همگام است</span>`;
                    addLog('✅ localStorage و Cookie همگام هستند', 'success');
                } else {
                    syncRow.className = 'row error';
                    syncRow.innerHTML = `<span class="label">وضعیت Sync:</span><span class="value">❌ Token ها مختلف هستند!</span>`;
                    addLog('❌ Token در localStorage و Cookie متفاوت است!', 'error');
                }
            } else if (localToken && !cookieToken) {
                syncRow.className = 'row warning';
                syncRow.innerHTML = `<span class="label">وضعیت Sync:</span><span class="value">⚠️ Token در localStorage هست ولی Cookie نیست</span>`;
                addLog('⚠️ در حال ساخت Cookie از localStorage...', 'warning');
                
                // ساخت Cookie
                document.cookie = 'auth_token=' + localToken + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                addLog('🍪 Cookie ساخته شد!', 'success');
                
                setTimeout(() => {
                    addLog('🔄 صفحه رو reload کن تا PHP Cookie رو ببینه', 'warning');
                }, 500);
            } else if (!localToken && cookieToken) {
                syncRow.className = 'row warning';
                syncRow.innerHTML = `<span class="label">وضعیت Sync:</span><span class="value">⚠️ Cookie هست ولی localStorage نیست</span>`;
                addLog('⚠️ در حال ساخت localStorage از Cookie...', 'warning');
                
                localStorage.setItem('auth_token', cookieToken);
                addLog('💾 localStorage به‌روز شد!', 'success');
            } else {
                syncRow.className = 'row error';
                syncRow.innerHTML = `<span class="label">وضعیت Sync:</span><span class="value">❌ هیچ Token ای موجود نیست</span>`;
                addLog('❌ نیاز به لاگین دارید', 'error');
            }
        }
        
        // Clear All
        function clearAll() {
            if (confirm('آیا مطمئن هستید؟')) {
                localStorage.removeItem('auth_token');
                localStorage.removeItem('user_data');
                document.cookie = 'auth_token=; path=/; max-age=0; SameSite=Lax';
                addLog('🗑️ همه Token ها پاک شدند', 'info');
                setTimeout(() => window.location.reload(), 1000);
            }
        }
        
        // Run tests on load
        window.addEventListener('DOMContentLoaded', function() {
            addLog('🚀 شروع بررسی سیستم...', 'info');
            testSync();
            
            const token = localStorage.getItem('auth_token');
            if (token) {
                document.getElementById('token-display').innerHTML = '<div class="code"><strong>Token کامل:</strong><br>' + token + '</div>';
            }
        });
    </script>
</body>
</html>

