<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/otp-service.php';
require_once __DIR__ . '/../includes/functions.php';

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$phone = $input['phone'] ?? '';
$otp = $input['otp'] ?? '';

// Validate
$phone = convertPersianToEnglish($phone);
$otp = convertPersianToEnglish($otp);

if (!validateMobile($phone)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'شماره موبایل نامعتبر است']);
    exit;
}

if (strlen($otp) !== 4 || !ctype_digit($otp)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'کد تایید باید 4 رقم باشد']);
    exit;
}

// Verify OTP
$otpService = new OTPService();
$result = $otpService->verifyOTP($phone, $otp);

if ($result['success']) {
    // Check if user exists
    $user = getUserByMobile($phone);
    
    if (!$user) {
        // New user - return flag for automatic registration
        echo json_encode([
            'status' => 'ok',
            'verified' => true,
            'new_user' => true,
            'phone' => $phone,
            'message' => 'کد تایید صحیح است. در حال ثبت نام خودکار...'
        ]);
    } else {
        // Existing user - login directly (OTP already verified)
        // Set session
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['mobile'] = $user['mobile'];
        $_SESSION['email'] = $user['email'] ?? '';
        $_SESSION['is_admin'] = $user['is_admin'] ?? 0;
        
        // Regenerate session ID for security
        session_regenerate_id(true);
        
        // Generate auth token using the standard function
        $token = createAuthToken($user['id']);
        
        echo json_encode([
            'status' => 'ok',
            'verified' => true,
            'new_user' => false,
            'message' => 'ورود موفقیت‌آمیز',
            'token' => $token,
            'user' => [
                'id' => $user['id'],
                'mobile' => $user['mobile'],
                'email' => $user['email'] ?? '',
                'is_admin' => $user['is_admin'] ?? 0
            ]
        ]);
    }
} else {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'verified' => false,
        'message' => $result['message']
    ]);
}

